<?php

namespace App\Moron\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Tasa extends Model 
{

    protected $table = 'tasas';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('nombre');
    protected $visible = array('nombre');

    public function panel()
    {
        return $this->belongsTo('App\Moron\Models\Panel');
    }

    public function info()
    {
        return $this->hasOne('App\Moron\Models\InformacionTasa');
    }

}